import time
import board
import busio
from i2c_button import I2C_Button

try:
    i2c_bus = board.I2C()
    print( "i2c_bus initialized" )
except:
    print( "i2c bus failed to initialize" )
    i2c_bus = False

if i2c_bus:
    try:
        button = I2C_Button( i2c_bus )
        print( "button initialized" )
        print("firmware version", button.version)
        print("debounce ms", button.debounce_ms)
    except:
        button = False
        print( "button failed to initialize" )

if button:
    button.led_bright = 1
    recording_mode = 0
    recording_number_of_modes = 2
    last_clicked = False
    is_pressed = False
    last_pressed = False
    button.clear()
    loop_count = 0

    while True:
        print( "loop_count", loop_count )
        button_values = button.status

        if recording_mode == 0:
            button.led_bright = 1
        if recording_mode == 1:
            button.led_bright = 128

        if button_values[ 2 ]:
            is_pressed = True
            if last_pressed:
                recording_mode = (recording_mode + 1) % recording_number_of_modes
                last_pressed = False
            else:
                last_pressed = True
        else:
            is_pressed = False





        if button_values[ 1 ]:
            clicked = True
        else:
            clicked = False







        if False:
            #print("status", button_values)
            if False: #clicked and not is_pressed:
                print( "clicked" )
                recording = False
                record_one = True
                print( "record_one" )

            if clicked and is_pressed:
                print("last click ms", button.last_click_ms)
                print("last press ms", button.last_press_ms)
                print( "newly pressed" )
                recording = not recording
                if recording:
                    print( "recording" )
                else:
                    print( "paused" )
                button.clear()
            #elif clicked:
            #    print( "only clicked" )
            #    button.clear()
            #print("last click ms", button.last_click_ms)
            #print("last press ms", button.last_press_ms)
        time.sleep(.1)
        loop_count += 1
